# Offline Multi-Agent Reinforcement Learning with Implicit Global-to-Local Value Regularization

## Installation
### Create environments/
``` Bash
conda create -n env_name python=3.9
conda activate env_name
cd Offline-MARL
pip install -r requirements.txt
```

### Multi-agent MuJoCo
Following the instructios in https://github.com/openai/mujoco-py and https://github.com/schroederdewitt/multiagent_mujoco to setup a mujoco environment. In the end, remember to set the following environment variables:
``` Bash
LD_LIBRARY_PATH=${HOME}/.mujoco/mujoco201/bin
LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libGLEW.so
```

## How to run
The full script can be found at [algos/OMIGA.py]. Before running the code, it is necessary to check if the config file at [configs/config.py] is correct and set the **data_dir** to the folder location where the dataset is located. After that you can run the code:
``` Bash
cd Offline-MARL
python run_mujoco.py
```

## Weights and Biases Online Visualization Integration
This codebase can also log to [W&B online visualization platform](https://wandb.ai/site). To log to W&B, you first need to set your W&B API key environment variable:
```
export WANDB_API_KEY='YOUR W&B API KEY HERE'
```
Then you can run experiments with W&B logging turned on:
```
python run_mujoco.py --wandb=True
```


## Multi-Agent MuJoCo Datasets
Due to file size limitations, we are currently unable to upload all multi-agent MuJoCo datasets. We will provide all the datasets after this paper is reviewed.
